/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.path;

import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.RcsObject;
import com.ibm.hwmca.fw.rcs.link.LinkNotActiveException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledListener;
import com.ibm.hwmca.fw.rcs.path.PathEvent;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathIdentifier;
import com.ibm.hwmca.fw.rcs.path.PathNotOpenException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.PathState;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.UUID;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class RcsPath
extends RcsObject {
    protected UUID uuid;
    protected PathState state;
    protected PathPlatform platform;
    protected PathPriority priority;
    protected PathCancelReason cancelReason;
    private static final long TIMEOUT = 14400000L;
    protected PathIdentifier pathId;
    protected LocalizableText text;
    protected Date origDate;
    protected String origSystem;
    protected PathCancelledListener cancelListener;
    private List supportedLinks;
    protected Object lock = new Object();
    private static final int CANCEL_TIMEOUT = 300000;
    private static Timer cancelTimer = new NamedTimer(true, "RcsPath Cancel Timer");
    private TimerTask cancelTask;
    private Map linkData = new HashMap();
    private RcsLink cLink = null;
    private static final int SOCKET_RETAIN = 0;
    private static final int SOCKET_SERVICE_AGENT = 1;
    private static final int SOCKET_REMOTE_SUPPORT = 2;
    private static final int SOCKET_SYSTEM_AUTHENTICATION = 3;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$RcsLink;

    public RcsPath() {
        this(PathPlatform.GENERIC, PathPriority.LOW, new LocalizableText("Rcs Path"));
    }

    public RcsPath(PathPriority priority, LocalizableText text) {
        this(PathPlatform.GENERIC, priority, text);
    }

    public RcsPath(PathPlatform platform, PathPriority priority, LocalizableText text) {
        this.platform = platform;
        this.priority = priority;
        this.text = text;
        this.uuid = UUIDFactory.generate();
        this.state = PathState.READY;
        this.origDate = new Date();
        this.origSystem = "localhost";
        this.pathId = new PathIdentifier(this);
        this.ttrace("<-> RcsPath( " + platform + ", " + priority + ", " + text + " )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAvailability() throws InvalidStateException, PathCancelledException {
        this.ttrace("--> waitForAvailability()");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state != PathState.READY) {
                    throw new InvalidStateException(this.state, PathState.READY);
                }
                this.state = PathState.QUEUED;
                PathManager.getPathManager().addPath(this);
                this.ftrace("  ] sleeping after addPath() until notified");
                while (this.state == PathState.QUEUED) {
                    this.lock.wait();
                }
                this.ftrace("  ] waking after addPath()");
                if (this.state == PathState.CANCELLED) {
                    throw new PathCancelledException();
                }
            }
            catch (PathCancelledException e) {
                throw e;
            }
            catch (InvalidStateException e) {
                throw e;
            }
            catch (Exception e) {
                this.logInfoError("Exception occurred in RcsPath.waitForAvailability()\nRCS State: " + this.state + "\n" + "RCS Platform: " + this.platform + "\n" + "RCS Priority: " + this.priority + "\n" + "RCS cancel: " + this.cancelReason + "\n" + "RCS pathId: " + this.pathId + "\n" + "RCS text: " + this.text + "\n" + "RCS date: " + this.origDate + "\n" + "RCS sys: " + this.origSystem + "\n", e);
            }
        }
        this.ttrace("<-- waitForAvailability()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InvalidStateException, PathCancelledException, PathFailedException {
        this.ttrace("--> open()");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.cancelTask != null) {
                    this.cancelTask.cancel();
                }
                if (this.state != PathState.WAITING) {
                    throw new InvalidStateException(this.state, PathState.WAITING);
                }
                this.state = PathState.OPENING;
                PathManager.getPathManager().openPath(this.pathId);
                this.ftrace("  ] sleeping after openPath() until notified");
                long timestamp = System.currentTimeMillis();
                while (this.state == PathState.OPENING && System.currentTimeMillis() - timestamp < 14400000L) {
                    this.lock.wait(14400000L);
                }
                this.ftrace("  ] waking after openPath()");
                if (this.state == PathState.OPENING) {
                    throw new InvalidStateException();
                }
                if (this.state == PathState.CANCELLED) {
                    if (this.cancelReason == PathCancelReason.LINK) {
                        PathFailedException e = new PathFailedException();
                        e.setReturnCode(PathManager.getPathManager().getReturnCode());
                        throw e;
                    }
                    throw new PathCancelledException();
                }
            }
            catch (PathCancelledException e) {
                throw e;
            }
            catch (PathFailedException e) {
                throw e;
            }
            catch (InvalidStateException e) {
                throw e;
            }
            catch (Exception e) {
                this.logInfoError("Exception occurred in RcsPath.open()\nRCS State: " + this.state + "\n" + "RCS Platform: " + this.platform + "\n" + "RCS Priority: " + this.priority + "\n" + "RCS cancel: " + this.cancelReason + "\n" + "RCS pathId: " + this.pathId + "\n" + "RCS text: " + this.text + "\n" + "RCS date: " + this.origDate + "\n" + "RCS sys: " + this.origSystem + "\n", e);
            }
        }
        this.ttrace("<-- open()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.ttrace("--> close()");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == PathState.ACTIVE) {
                    this.state = PathState.CLOSING;
                } else {
                    this.state = PathState.CANCELLED;
                    this.cancelReason = PathCancelReason.APPLICATION;
                    this.lock.notifyAll();
                }
            }
            catch (Exception e) {
                this.ftrace("notify exception: " + e);
            }
        }
        try {
            PathManager.getPathManager().closePath(this.pathId);
            this.state = PathState.READY;
        }
        catch (Exception e) {
            this.ftrace("Exception from PathManager.closePath(): " + e);
        }
        this.ttrace("<-- close()");
    }

    public boolean fail() {
        boolean fail = PathManager.getPathManager().failLink();
        this.close();
        this.ttrace("<-> fail() [" + fail + "]");
        return fail;
    }

    public void setCancelListener(PathCancelledListener listener) throws NullPointerException {
        this.ttrace("--> setCancelListener( " + listener + " )");
        if (listener == null) {
            throw new NullPointerException("The specified listener was null");
        }
        this.cancelListener = listener;
        this.ttrace("<-- setCancelListener()");
    }

    public PathCancelReason getCancelReason() {
        if (this.cancelReason == null) {
            this.cancelReason = PathCancelReason.ERROR;
        }
        this.ttrace("<-> getCancelReason() [" + this.cancelReason + "]");
        return this.cancelReason;
    }

    public void setDate(Date date) {
        this.ttrace("<-> setDate( " + this.origDate + " )");
        this.origDate = (Date)date.clone();
    }

    public Date getDate() {
        this.ttrace("<-> getDate() [" + this.origDate + "]");
        return (Date)this.origDate.clone();
    }

    public void setSystem(String system) {
        this.ttrace("<-> setSystem( " + system + " )");
        this.origSystem = system;
    }

    public String getSystem() {
        this.ttrace("<-> getSystem() [" + this.origSystem + "]");
        return this.origSystem;
    }

    public InetAddress getLinkAddress() throws PathNotOpenException {
        if (this.state != PathState.ACTIVE) {
            throw new PathNotOpenException();
        }
        InetAddress ip = null;
        try {
            ip = PathManager.getPathManager().getLinkAddress();
        }
        catch (LinkNotActiveException e) {
            throw new PathNotOpenException(e);
        }
        catch (Exception e) {
            this.ftrace("Exception: " + e);
        }
        this.ttrace("<-> getLinkAddress() [" + ip + "]");
        return ip;
    }

    public void setSupportedLinkTypes(List links) throws IllegalArgumentException {
        this.ttrace("--> setSupportedLinkTypes( " + links + " )");
        if (links == null) {
            this.supportedLinks = null;
            return;
        }
        Iterator i = links.iterator();
        while (i.hasNext()) {
            Class c;
            if ((class$com$ibm$hwmca$fw$rcs$link$RcsLink == null ? RcsPath.class$("com.ibm.hwmca.fw.rcs.link.RcsLink") : class$com$ibm$hwmca$fw$rcs$link$RcsLink).isAssignableFrom(c = (Class)i.next())) continue;
            throw new IllegalArgumentException(c + " is not a sublcass of " + (class$com$ibm$hwmca$fw$rcs$link$RcsLink == null ? (class$com$ibm$hwmca$fw$rcs$link$RcsLink = RcsPath.class$("com.ibm.hwmca.fw.rcs.link.RcsLink")) : class$com$ibm$hwmca$fw$rcs$link$RcsLink));
        }
        this.supportedLinks = links;
        this.ttrace("<-- setSupportedLinkTypes()");
    }

    public List getSupportedLinkTypes() {
        this.ttrace("<-> getSupportedLinkTypes() [" + this.supportedLinks + "]");
        return this.supportedLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(PathEvent event, Object info) {
        this.ttrace("--> sendEvent( " + event + ", " + info + " )");
        Object object = this.lock;
        synchronized (object) {
            if (event == PathEvent.READY) {
                if (this.state == PathState.QUEUED) {
                    this.state = PathState.WAITING;
                    if (this.cancelTask != null) {
                        this.cancelTask.cancel();
                    }
                    this.ftrace("Creating a new TimerTask, and scheduling for 300000 seconds");
                    this.cancelTask = new CancelTimerTask(this);
                    cancelTimer.schedule(this.cancelTask, 300000L);
                } else {
                    this.state = PathState.CANCELLED;
                    this.close();
                }
                this.lock.notifyAll();
            } else if (event == PathEvent.OPENED) {
                this.state = this.state == PathState.OPENING ? PathState.ACTIVE : PathState.CANCELLED;
                this.lock.notifyAll();
            } else if (event == PathEvent.CANCELLED) {
                this.cancelReason = (PathCancelReason)info;
                if (this.state == PathState.OPENING) {
                    this.state = PathState.CANCELLED;
                } else {
                    this.state = PathState.CANCELLED;
                    if (this.cancelListener != null) {
                        this.cancelListener.pathCancelled(this.cancelReason);
                    }
                }
                this.lock.notifyAll();
            }
        }
        this.ttrace("<-- sendEvent()");
    }

    public void sendEvent(PathEvent event) {
        this.ttrace("<-> sendEvent( " + event + " )");
        this.sendEvent(event, null);
    }

    public void cancel(PathCancelReason reason) {
        this.ttrace("<-> cancel( " + reason + " )");
        this.sendEvent(PathEvent.CANCELLED, reason);
    }

    public void setDescription(LocalizableText text) {
        this.ttrace("<-> setDescription( " + text + " )");
        this.text = text;
    }

    public LocalizableText getDescription() {
        return this.text;
    }

    public PathState getState() {
        return this.state;
    }

    public PathPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(PathPlatform platform) {
        this.ttrace("<-> setPlatform() [" + platform + "]");
        this.platform = platform;
    }

    public PathPriority getPriority() {
        return this.priority;
    }

    public void setPriority(PathPriority priority) {
        this.ttrace("<-> setPriority() [" + priority + "]");
        this.priority = priority;
    }

    public PathIdentifier getPathIdentifier() {
        if (this.pathId == null) {
            this.pathId = new PathIdentifier(this);
        }
        this.ttrace("<-> getPathIdentifier() [" + this.pathId + "]");
        return this.pathId;
    }

    public UUID getPathId() {
        return this.uuid;
    }

    public boolean isOpen() {
        return this.state == PathState.ACTIVE;
    }

    public boolean isHighPerformancePath() throws PathNotOpenException {
        if (this.state != PathState.ACTIVE) {
            throw new PathNotOpenException();
        }
        boolean hpl = false;
        try {
            hpl = PathManager.getPathManager().isHighPerformanceLink();
        }
        catch (LinkNotActiveException e) {
            throw new PathNotOpenException(e);
        }
        catch (Exception e) {
            this.ftrace("Exception: " + e);
        }
        this.ttrace("<-> isHighPerformancePath() [" + hpl + "]");
        return hpl;
    }

    public void setLinkData(String key, Object value) {
        this.linkData.put(key, value);
    }

    public Object getLinkData(String key) {
        return this.linkData.get(key);
    }

    public void setRcsLink(RcsLink pLink) {
        this.cLink = pLink;
    }

    protected RcsLink getRcsLink() {
        return this.cLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket(int pServer) throws InvalidStateException, IOException {
        this.ttrace("--> getSocket( " + pServer + " )");
        Socket mSocket = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.state != PathState.ACTIVE) {
                throw new InvalidStateException(this.state, PathState.ACTIVE);
            }
        }
        this.ttrace("<-- getSocket() [" + mSocket + "]");
        return mSocket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CancelTimerTask
    extends TimerTask {
        RcsPath path;

        public CancelTimerTask(RcsPath path) {
            RcsPath.this.ttrace("<-> CancelTimerTask()");
            this.path = path;
        }

        public void run() {
            RcsPath.this.ttrace("--> CancelTimerTask.run()");
            try {
                if (this.path.getState() == PathState.WAITING) {
                    this.path.close();
                }
            }
            catch (Exception e) {
                RcsPath.this.ftrace("Exception during the CancelTimerTask");
                RcsPath.this.logInfo(e);
            }
            RcsPath.this.ttrace("<-- CancelTimerTask.run()");
        }
    }
}

